local assets=
{
	Asset("ANIM", "anim/firearmor.zip"),
 Asset("IMAGE", "images/inventoryimages/firearmor.tex"),
 Asset("ATLAS", "images/inventoryimages/firearmor.xml"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function firetwo(inst, owner)
     if owner:HasTag("fire1") and owner:HasTag("fire2") and owner:HasTag("fire3") then
    inst.components.armor:InitCondition(2000, 1)
    inst.components.equippable.walkspeedmult = 1.5
    inst.components.insulator.insulation =60 * 18
    else
    inst.components.armor:InitCondition(2000, 0.8)
    inst.components.equippable.walkspeedmult = 0.9
    inst.components.insulator.insulation =60 * 8
      end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "firearmor", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold") 
        owner:AddTag("fire2")
    inst.task = inst:DoPeriodicTask(0.5, function() firetwo(inst, owner) end)

    inst.drainhealthfn = function(attacked, data)
          owner.components.health:DoDelta(6)
    end

    inst:ListenForEvent("attacked", inst.drainhealthfn, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
        owner:RemoveTag("fire2")
inst.task:Cancel() inst.task = nil
    inst:RemoveEventCallback("attacked", inst.drainhealthfn, owner)
    inst.components.armor:InitCondition(2000, 0.8)
    inst.components.equippable.walkspeedmult = 0.9
    inst.components.insulator.insulation =60 * 8

end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("armor_marble")
    inst.AnimState:SetBuild("firearmor")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/firearmor.xml"
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(2000, 0.8)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.walkspeedmult = 0.9
    inst:AddTag("firearmor")
	inst:AddComponent("insulator")
    inst.components.insulator.insulation =60 * 8
    return inst
end

return Prefab( "common/inventory/firearmor", fn, assets) 